﻿//////////////////////////////////////////////
// ComponentManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Component.h"
#include "ComponentType.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>
#include <string>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ComponentManager final : public nkCommon::MaybeSingletonClass<ComponentManager>
	{		
		public :

			// Getters
			System* getSystem () const ;

			// Manipulations
			Component* createOrRetrieve (nkMemory::StringView name, COMPONENT_TYPE componentType) ;
			Component* record (nkMemory::StringView name, nkMemory::UniquePtr<Component> resource) ;
			Component* get (nkMemory::StringView name) const ;
			Component* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Component> relinquish (nkMemory::StringView name) ;

		private :

			// Constructor, destructor
			ComponentManager (bool isSingleton) noexcept ;
			ComponentManager (System* system) noexcept ;
			ComponentManager (const ComponentManager&) = delete ;

			// Operators
			ComponentManager& operator= (const ComponentManager&) = delete ;

		private :

			// Attributes
			std::unordered_map<std::string, nkMemory::UniquePtr<Component>> _components ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<ComponentManager> ;
			friend class System ;
	} ;
}